<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSubscriptionIdToCompanyFeatureUsage extends Migration
{
    public function up()
    {
        Schema::table('company_feature_usage', function (Blueprint $table) {
            $table->unsignedBigInteger('Subscription_id')->nullable()->after('Plan_id');
            $table->foreign('Subscription_id')->references('Subscription_id')->on('subscriptions')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('company_feature_usage', function (Blueprint $table) {
            $table->dropForeign(['Subscription_id']);
            $table->dropColumn('Subscription_id');
        });
    }
}
